/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.geometry.Position;

public class Canvas
implements ImageFilter {
    private final int width;
    private final int height;
    private final Position position;
    private final Color fillColor;
    private final boolean crop;

    public Canvas(int n, int n2, Position position2) {
        this(n, n2, position2, true, null);
    }

    public Canvas(int n, int n2, Position position2, boolean bl) {
        this(n, n2, position2, bl, null);
    }

    public Canvas(int n, int n2, Position position2, Color color) {
        this(n, n2, position2, true, color);
    }

    public Canvas(int n, int n2, Position position2, boolean bl, Color color) {
        this.width = n;
        this.height = n2;
        this.position = position2;
        this.crop = bl;
        this.fillColor = color;
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        int n = this.width;
        int n2 = this.height;
        if (!this.crop && bufferedImage.getWidth() > this.width) {
            n = bufferedImage.getWidth();
        }
        if (!this.crop && bufferedImage.getHeight() > this.height) {
            n2 = bufferedImage.getHeight();
        }
        Point point = this.position.calculate(n, n2, bufferedImage.getWidth(), bufferedImage.getHeight(), 0, 0, 0, 0);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        Graphics graphics = bufferedImage2.getGraphics();
        if (this.fillColor == null && !bufferedImage.getColorModel().hasAlpha()) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.width, this.height);
        } else if (this.fillColor != null) {
            graphics.setColor(this.fillColor);
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.drawImage(bufferedImage, point.x, point.y, null);
        graphics.dispose();
        return bufferedImage2;
    }
}

